

export class SalesPlanHourWidget {
	
	
	tpl = `
	
	<div class="spdw day-count-{{dayList.length}}">
		
		<div class="week-list">
			<div class="article-name-placeholder"></div>
			<div class="week-list-items" ez-for="weekList" ez-item="w">
				<div class="week week-{{w.count}}">Week {{w.weekno}} - {{ w.yearno }}</div>
			</div>
		</div>
		
		<div class="day-list">
			<div class="article-name-placeholder">&nbsp;</div>
			<div class="day-list-items" ez-for="dayList" ez-item="d">
				<div class="day {{ d.ymd == currentYmd ? 'current-date' : ''  }}" [date]="d.date" title="{{ format_datetext_short(d.date) }}">
					{{ _('daynoshort.'+d.date.getDay()) }}
					
					<div>
						{{ d.date.getDate() }}
						{{ _('monthshort.'+(d.date.getMonth()+1)) }}
					</div>
				</div>
			</div>
		</div>

		<div ez-if="articles.length == 0" class="no-results">
			Geen resultaten gevonden
		</div>
		<div class="article-list" ez-for="articles" ez-item="art">
			<div class="article article-{{art.articleId}} article-pricingmethod-{{art.pricingMethod}}" [article]=art>
				<div class="article-name">
					{{art.shortDescription}}
				</div>
				<div class="article-day-items" ez-for="dayList" ez-item="d">
					<div class="day-item day-item-{{d.dayNo}}" [day]="d"></div>
				</div>
			</div>
		</div>
	</div>
	
	
	`;
	
	container = null;
	
	ezTpl = null;
	
	startWeek = null;
	startYear = null;
	weeks = 1;
	
	selectedDate = null;
	
	articles = [];
	weekList = [];
	dayList = [];
	
	slotplans = [];
	
	callback_selectPeriod = null;
	
	
	constructor() {
		
	}
	
	
	init(c) {
		this.container = c;
	}
	
	setCallbackSelectPeriod( func ) { this.callback_selectPeriod = func; }
	
	
	setWeeks(no) { this.weeks = parseInt(no); }
	setStartWeek( year, weekno ) {
		this.startYear = parseInt(year);
		this.startWeek = parseInt(weekno);
	}
	
	setArticles(arts) {
		this.articles = arts;
	}
	
	setSelectedDate(d) {
		this.selectedDate = d;
		this.render();
	}
	
	startDate() {
		if (this.selectedDate)
			return this.selectedDate;
		
		return week2date( this.startYear, this.startWeek );
	}
	
	endDate() {
		if (this.selectedDate)
			return this.selectedDate;
		
		let sd = str2date( this.startDate() );
		sd.setHours(12);
		
		let ed = str2date( next_week( sd, this.weeks-1 ) );
		while ( ed.getDay() != 0 ) {
			ed = str2date( next_day( ed ) );
		}
		
		return ed;
	}
	
	buildDates() {
		
		let d = this.startDate();
		let numd = date2number(d);
		
		let end = this.endDate();
		let num_end = date2number(end);
		
		let dates = new Array();
		let weeks = new Array();
		while (numd <= num_end) {
			// push date
			dates.push({
				date: d,
				dayNo: d.getDay() == 0 ? 7 : d.getDay(),
				ymd: format_date(d)
			});
			
			// push week
			let weekno = week_no(d);
			let yearno = week_year(d);
			
			let weekpos = -1;
			for(let i in weeks) {
				if (weeks[i].weekno == weekno && weeks[i].yearno == yearno) {
					weekpos = i;
					break;
				}
			}
			
			if ( weekpos == -1) {
				weeks.push({
					weekno: weekno,
					yearno: yearno,
					count: 1
				});
			}
			else {
				weeks[weekpos].count++;
			}
			
			
			// next
			d = str2date(next_day(d));
			numd = date2number(d);
		}
		
		
		this.weekList = weeks;
		this.dayList = dates;
	}
	
	
	
	loadOccupation() {
		let articleIds = [];
		for(let i in this.articles) {
			articleIds.push( this.articles[i].articleId );
		}
		
		let startDate = null;
		let endDate = null;
		if (this.dayList.length > 0) {
			startDate = format_date( this.dayList[0].date );
			endDate = format_date( this.dayList[ this.dayList.length-1 ].date);
		}
		
//		console.log('hierr..');
		postUrl('/service/sales/plan.do', {
			a: 'occupation',
			articleIds: articleIds,
			startDate: startDate,
			endDate: endDate
		}).then( async function(e) {
			let json = await e.json();
			this.slotplans = json.slotplans;
			
			this.renderSlotplan( );
			
			this.renderOccupation();
			
			this.bindEvents();
		}.bind(this) );
	}
	
	lookupSlotplan( slotplanId ) {
		for(let i in this.slotplans) {
			if (this.slotplans[i].slotplanId == slotplanId)
				return this.slotplans[i];
		}
		
		return null;
	}
	
	renderSlotplan( json ) {
		
		for( let i in this.articles ) {
			let art = this.articles[i];
			if (art.pricingMethod != 'slotplan') continue;
			
			let a = $('.article-list .article-' + art.articleId);
			
			// remove previous rendered old
			a.find('.slotitem').remove();
			
			let slotplan = this.lookupSlotplan( art.slotplanId );
			if (!slotplan)
				continue;
			
//			console.log( 'hier', art, slotplan );
			// render slots
			for(let i in slotplan.slotitemHours) {
				this.renderSlotitemHour( art, slotplan, slotplan.slotitemHours[i] );
			}
		}
	}
	renderSlotitemHour( art, slotplan, slotitemHour ) {
		
		let a = $('.article-list .article-' + art.articleId);
		
		
		let shd = slotplan.startHour;
		let ehd = slotplan.endHour;
		
		let hoursInDay = (ehd - shd)+1;
		
		
		for(let i in slotitemHour.days) {
			let day = slotitemHour.days[i];
			
			let dayc = $(a).find('.article-day-items .day-item-'+day);	// dayc = dayContainer
			
			let w = dayc.width();
			
			let si = $('<div class="slotitem" />');
			si.get(0).slotitemHour = slotitemHour;
			
			// calc width
			let width = slotitemHour.duration / (hoursInDay*60) * w;
			if (width < 0) width = 1;
			si.css('width', width);
			
			// calc pos
			let toks = slotitemHour.startTime.split(':');
			let startHour = parseInt( toks[0] );
			let endMin = parseInt( toks[1] );
			
			let startMin = ((startHour - shd) * 60)+endMin;
			let l = startMin / (hoursInDay*60) * w;
			
			si.css('left', l);
			
			si.css('height', '100%');
			si.css('top', '0');
			
			dayc.append( si );
		}
		
	}
	
	renderOccupation() {
		
	}
	
	
	bindEvents() {
		let arts = $('.spdw .article-list > .article');
		
		console.log('arts.length', arts.length);
		
		arts.each(function(index, node) {
			
			let art = node.article;
			
			if ( $(node).hasClass('article-pricingmethod-slotplan') ) {
				
				
				$(node).find('.slotitem').click(function(evt) {
					let si = evt.currentTarget;
					let day = $(si).closest('.day-item').get(0).day;
					
					let slotitemHour = si.slotitemHour;
					
					this.callback_selectPeriod({
						article: art,
						day: day,
						slotitemHour: slotitemHour
					});
				}.bind(this));
			}
			else {
				$(node).find('.day-item').click(function(evt) {
					let d = evt.currentTarget;
					let day = d.day;
					
					this.callback_selectPeriod({
						article: art,
						day: day
					});
				}.bind(this));
			}
			
		}.bind(this));
	}
	
	
	
	render() {
		this.buildDates();
		
		this.ezTpl = new EzTemplate( this.container );
		this.ezTpl.setVar('weekList', this.weekList);
		this.ezTpl.setVar('dayList', this.dayList);
		this.ezTpl.setVar('articles', this.articles);
		
		let now = new Date();
		this.ezTpl.setVar('currentYmd', format_date(now));
		
		this.ezTpl.loadHtml( this.tpl );
		
		this.ezTpl.render();
		
//		console.log('render :)');
		this.loadOccupation();

		
		$(this.container).find('.day-list .day').on('click', function(evt) {
			if (this.selectedDate == null) {
				let o = evt.currentTarget;
				this.setSelectedDate( o.date );
			}
			else {
				this.setSelectedDate( null );
			}
		}.bind(this));
		
		if (this.selectedDate) {
			$(this.container).find('.week-list .week').on('click', function(evt) {
				this.setSelectedDate(null);
			}.bind(this));
		}
	}
	
	
}

